library(sjstats)
library(groupedstats)
library(lsr)
library(ggplot2)

db = file.choose()

dat <- read.csv(file = db, header = T, sep = ",")
dat$subID <- as.factor(dat$subID)

fig <- grouped_summary(data = dat, grouping.vars = list(condition, Time), measures = dat, measures.type = "numeric")
fig

m <- aov(dat ~ condition*Time + Error(subID/(Time*condition)), data = dat)
summary(m)

Patient <- "darkgoldenrod1"
Actor <-  "mediumaquamarine"

data_summary <- function(x) {
  mu <- mean(x)
  sigma1 <- mu-sd(x)
  sigma2 <- mu+sd(x)
  return(c(y=mu,ymin=sigma1,ymax=sigma2))
}


dat$condition <- factor(dat$condition, level = c("Patient","Actor")) # take the name of Figure 1-source data 1.xlsx as the example
dat$Time <- factor(dat$Time, level = c("round_1st","round_2nd")) # take the name of Figure 1-source data 1.xlsx as the example

ggplot(dat,aes(x=factor(Time),y=dat, colour = factor(Time))) +  
  scale_y_continuous(name="Scores of Pain Intensity",limits=c(0,10), breaks=seq(0,10,2)) + # take the name of Figure 1-source data 1.xlsx as the example
  geom_violin(alpha=0.1, scale = "width", width = 0.6, position=position_dodge(0.7), 
              aes(fill = Time,group = interaction(Time, condition))) + 
  scale_fill_manual(values = c(Patient,Actor)) +   
  scale_colour_manual(values = c(Patient,Actor)) + 
  geom_point(size = 1, shape = 16, position=position_jitterdodge(jitter.width = 0.4,dodge.width = 0.7),
             aes(group = interaction(condition, Time)))+ 

  stat_summary(fun.data = data_summary,aes(group = condition),position=position_dodge(0.7), size = 1, shape = 19) +  ### to add the bar
  stat_summary(fun.data = data_summary,aes(group = condition),geom = "line",linetype = "dashed", colour = "black", size = 1, position=position_dodge(0.7)) + 
  xlab(NULL) +
  theme(panel.background = element_rect(fill = "transparent"), 
        axis.line = element_line(size = 1, colour = "black"), 
        axis.ticks = element_line(size = 1, colour = "black"), 
        axis.title.y=element_text(color="Black", size=15, face="bold"),
        axis.ticks.length=unit(-0.25, "cm"), 
        axis.text.x = element_text(margin=unit(c(0.5,0.5,0.5,0.5), "cm")), 
        axis.text.y = element_text(margin=unit(c(0.5,0.5,0.5,0.5), "cm")),
        axis.text=element_text(colour = "black",size=15,face = "bold"), 
        axis.title.x=element_text(color="Black", size=15, face="bold"), 
        legend.title = element_blank())
